<?xml version="1.0"?>
<!--
    xrefs.mod.xsl - templates for cross references.
	$Id: xrefs.mod.xsl,v 1.5 2005/01/02 14:41:26 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- I use \autoref for all cross-links, although it still doesn't support all
     human languages (e.g. French is missing).  It is usable for dvi output,
     too.  By and large, I try to mimic the original Texinfo behaviour here
     (although I don't like it very much). -->

<!-- This is also a point where the Texinfo XML format is flawed.  The "See"
     for introducing a cross-reference is generated automatically so I cannot
     change it, but the "section" or "chapter" is not.  I could take this from
     the strings (see translation-strings.xml), but \autoref is good enough so
     far. -->

<xsl:template match="xref">
  <xsl:variable name="label">
    <xsl:apply-templates select="xrefnodename" mode="label"/>  <!-- See below -->
  </xsl:variable>
  <xsl:value-of select="concat('\autoref{',$label,'} [')"/>
  <xsl:choose>
    <xsl:when test="xrefprintedname">
      <xsl:apply-templates select="xrefprintedname"/>
    </xsl:when>
    <xsl:otherwise>
      <!-- Note that this is *not* the template below because of the mode! -->
      <xsl:apply-templates select="xrefnodename"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="concat('] \vpageref{',$label,'}')"/>
</xsl:template>

<xsl:template match="xrefnodename" mode="label">
  <xsl:call-template name="clean-up-identifier">
    <xsl:with-param name="identifier" select="."/>
  </xsl:call-template>
</xsl:template>

</xsl:stylesheet>
