<?xml version="1.0"?>
<!--
    urls.mod.xsl - routines for handling URLs, email addresses and hyperlinks.
	$Id: urls.mod.xsl,v 1.6 2005/01/02 23:54:36 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<!DOCTYPE xsl:stylesheet [
<!ENTITY bph           "&#x0082;">  <!-- Break permitted here -->
]>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Rather straightforward: The \href is correctly interpreted by both
     pdflatex and latex.  The first argument is the link target, the second is
     what's printed on paper and made clickable. -->

<xsl:template match="url">
  <xsl:text>\href{</xsl:text>
  <!-- Maybe there are &bph;'s from the Texinfo output.  Actually impossible,
       but who knows. -->
  <xsl:value-of select="translate(.,'&bph;','')"/>
  <xsl:text>}{</xsl:text>
  <xsl:call-template name="insert-url-breakpoints">  <!-- see below -->
    <xsl:with-param name="url">
      <xsl:apply-templates/>
    </xsl:with-param>
  </xsl:call-template>
  <xsl:text>}</xsl:text>
</xsl:template>

<!-- For emails, additionally to URLs I have to generate the associated name.
     The rest is the same as above. -->

<xsl:template match="email">
  <xsl:apply-templates select="emailname"/>
  <xsl:if test="emailname">
    <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:text>\href{</xsl:text>
  <xsl:value-of select="translate(concat('mailto:',emailaddress),'&bph;','')"/>
  <xsl:text>}{</xsl:text>
  <xsl:call-template name="insert-url-breakpoints">
    <xsl:with-param name="url">
      <xsl:apply-templates/>
    </xsl:with-param>
  </xsl:call-template>
  <xsl:text>}</xsl:text>
</xsl:template>

<!-- Besides the fact that I have to distinguish between three possible cases
     (as far as optional parameters are concerned), this is the same es above.
     -->

<xsl:template match="uref">
  <xsl:variable name="href-call" select="concat('\href{',translate(urefurl,'&bph;',''),'}{')"/>
  <xsl:choose>
    <xsl:when test="urefreplacement">
      <xsl:value-of select="$href-call"/>
      <xsl:apply-templates select="urefreplacement"/>
      <xsl:text>}</xsl:text>
    </xsl:when>
    <xsl:when test="urefdesc">
      <xsl:apply-templates select="urefdesc"/>
      <xsl:text> (</xsl:text>
      <xsl:value-of select="$href-call"/>
      <xsl:call-template name="insert-url-breakpoints">
        <xsl:with-param name="url">
          <xsl:apply-templates select="urefurl"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:text>})</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$href-call"/>
      <xsl:call-template name="insert-url-breakpoints">
        <xsl:with-param name="url">
          <xsl:apply-templates select="urefurl"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:text>}</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Here I insert allowed breakpoints in URLs manually.  Actually this should
     be done by hyperref, but hyperref does it improperly so that character
     protruding doesn't work anymore.

     Attention: This routine assumes that $url is delimited with string
     delimiters, e.g. the result of apply-templates on a text() node! -->

<xsl:template name="insert-url-breakpoints">
  <xsl:param name="url"/>
  <!-- I switch off uncontrolled (automatic) hyphenation in URLs. -->
  <xsl:text>{\hyphenrules{nohyphenation}</xsl:text>
  <xsl:call-template name="substitute-in-string">
    <xsl:with-param name="str">
      <xsl:call-template name="insert-breakpoints">
        <!-- The "select" attribute contains possible break points in URLs and
             email addresses -->
        <xsl:with-param name="break-after" select="'/:.@=_'"/>
        <xsl:with-param name="string">
          <xsl:call-template name="substitute-in-string">
            <!-- Line breaks at spaces within URLs (bad, but allowed) would be
                 very confusing.  -->
            <xsl:with-param name="str"
              select="translate(normalize-space($url),' ','&#xa0;')"/>
            <xsl:with-param name="look-for" select="'-'"/>
            <!-- I have to replace dashes with \xhyphen in order to have
                 correct character protruding. -->
            <xsl:with-param name="replace-with"
              select="concat($end-delimiter,'\xhyphen ',$start-delimiter)"/>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
    <!-- the "http://" mustn't be broken between the slashs. -->
    <xsl:with-param name="look-for" select="'/&bph;/'"/>
    <xsl:with-param name="replace-with" select="'//'"/>
  </xsl:call-template>
  <xsl:text>}</xsl:text>
</xsl:template>


</xsl:stylesheet>
