<?xml version="1.0"?>
<!--
    structuring.mod.xsl - templates for headings and such.
	$Id: structuring.mod.xsl,v 1.8 2005/01/02 23:53:38 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<!-- In the entity &is-appendix; I list all elements that are supposed to be
     part of the index, in a way that it can be used in an XPath
     predicate. -->

<!DOCTYPE xsl:stylesheet [
<!ENTITY is-appendix "self::appendix or self::appendixsec or
                      self::appendixsubsec or self::appendixsubsubsec">
]>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- The node infrastructure is irrelevant in the printed output. -->

<xsl:template match="menu | nodename | nodeprev | nodenext | nodeup">
  <!-- gobble -->
</xsl:template>

<xsl:template match="node[normalize-space(nodename) = 'Top']">
  <!-- Look for only one in the Top node: the table of contents.  Gobble the
       rest. -->
  <xsl:apply-templates select="descendant::contents"/>
</xsl:template>

<!-- The central structuring template.  Actually it is one big choose that
     generates the corresponding LaTeX structuring command.  I use the <title>
     element as the pivot because then I have direct access to the heading.
     But by and large this is insignificant. -->

<xsl:template match="title">
  <xsl:variable name="is-appendix" select="parent::*[&is-appendix;]"/>
  <!-- Is this the very first appendix element in the document? -->
  <xsl:if test="$is-appendix and not(preceding::*[&is-appendix;]) and
                not(parent::*[ancestor::*[&is-appendix;]])">
    <!-- If yes, then start the appendix. -->
    <xsl:text>\appendix&#10;</xsl:text>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="parent::chapter or parent::appendix">
      <xsl:text>\chapter{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::unnumbered">
      <xsl:text>\chapter*{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::section or parent::appendixsec">
      <xsl:text>\section{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::unnumberedsec">
      <xsl:text>\section*{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::subsection or parent::appendixsubsec">
      <xsl:text>\subsection{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::unnumberedsubsec">
      <xsl:text>\subsection*{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::subsubsection or parent::appendixsubsubsec">
      <xsl:text>\subsubsection{</xsl:text>
    </xsl:when>
    <xsl:when test="parent::unnumberedsubsubsec">
      <xsl:text>\subsubsection*{</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message>
        <xsl:text disable-output-escaping="yes">&lt;title&gt; element has unrecognised parent</xsl:text>
      </xsl:message>
      <xsl:text>{</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates/>  <!-- The heading -->
  <xsl:text>}</xsl:text>
  <xsl:apply-templates select="ancestor::node[descendant::title[1] = current()]/nodename" mode="label"/>
</xsl:template>

<!-- Texinfo's ...heading commands have a different structure.  There is no
     <title>, so I must treat them differently.  It is more simple
     actually. -->

<!-- FixMe: <majorheading> and <chapheading> start a new page at the moment,
     which is wrong. -->

<xsl:template match="majorheading | chapheading">
  <xsl:text>&#10;&#10;\chapter*{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="heading">
  <xsl:text>&#10;&#10;\section*{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="subheading">
  <xsl:text>&#10;&#10;\subsection*{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="subsubheading">
  <xsl:text>&#10;&#10;\subsubsection*{</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<!-- The table of contens.  Very simple. -->

<xsl:template match="contents">
  <xsl:text>\tableofcontents </xsl:text>
</xsl:template>

<!-- This is a very important template.  When we stumble over a <nodename>,
     this is an anchor, i.e. a \label in LaTeX.  Therefore I must generate a
     \label here, so that the chapter/appendix/section becomes referable.
     Note that every non-stared section has a number due to a secnumdepth of
     "5".  Also note that you can't include a prefix here like "sec:" because
     when I refer to it, I can't find out easily wheter the target is a figure
     or a section. -->

<xsl:template match="nodename" mode="label">
  <xsl:text>\label{</xsl:text>
  <xsl:call-template name="clean-up-identifier">
    <xsl:with-param name="identifier" select="."/>
  </xsl:call-template>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>
