<?xml version="1.0"?>
<!--
    blocks.mod.xsl - displays, examples. quotations, and such.
	$Id: blocks.mod.xsl,v 1.6 2005/01/02 23:53:14 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- FixMe: The definition of all the "block" (or "verbatim") environments may
     be not robust enough.  It is not wise to nest them.  This is not
     explicitly allowed in the Texinfo specification, however, I think it
     should be made possible (and it is possible to do so). -->

<!-- FixMe: Flushleft, flushright, and cartouche are still missing. -->

<xsl:template match="quotation">
  <xsl:text>\begin{quote}</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>\end{quote}</xsl:text>
</xsl:template>

<xsl:template match="verbatim">
  <xsl:text>\begin{display}\ttfamily&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{display}</xsl:text>
</xsl:template>

<xsl:template match="example" name="process-example">
  <xsl:text>\begin{display}\leftskip\standardmargin\ttfamily&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{display}</xsl:text>
</xsl:template>

<xsl:template match="display" name="process-display">
  <xsl:text>\begin{display}\leftskip\standardmargin&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{display}</xsl:text>
</xsl:template>

<!-- At the moment any explicit formatting in @lisp doesn't work.  But at least
     this could be fixed manually for any occuring formatting command.  Not
     elegant, but sensible I think.

     Alternatively, it may be possible to tweak the listings package that it
     interprets all LaTeX commands as is.  -->

<xsl:template match="lisp" name="process-lisp">
  <xsl:text>\begin{lstlisting}[language=lisp]&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{lstlisting}</xsl:text>
</xsl:template>

<xsl:template match="format" name="process-format">
  <xsl:text>\begin{display}&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;\end{display}</xsl:text>
</xsl:template>

<!-- Small veriants -->

<xsl:template match="smallexample">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-example"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smalllisp">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-lisp"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smalldisplay">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-display"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

<xsl:template match="smallformat">
  <xsl:text>\begin{small}</xsl:text>
  <xsl:call-template name="process-format"/>
  <xsl:text>\end{small}</xsl:text>
</xsl:template>

</xsl:stylesheet>
