/* $Id: check_path.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <string.h>

#include "path.h"
#include "check_path.h"

START_TEST (check_root)
{
  path_t path = root_path ();
  fail_if (!path);
  fail_unless (0 == strcmp ("/", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_append1)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "foo");

  fail_unless (0 == strcmp ("/foo", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_append2)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "foo/");

  fail_unless (0 == strcmp ("/foo", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_append3)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "foo/bar/");

  fail_unless (0 == strcmp ("/foo/bar", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_append4)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "foo////bar////");

  fail_unless (0 == strcmp ("/foo/bar", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_replace)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "/qux/wibble/");
  path_add (path, "/foo/bar");

  fail_unless (0 == strcmp ("/foo/bar", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_remove_part1)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "/foo/bar");
  remove_last_path_part (path);

  fail_unless (0 == strcmp ("/foo", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_remove_part2)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "/foo/bar");
  remove_last_path_part (path);
  remove_last_path_part (path);

  fail_unless (0 == strcmp ("/", path_str (path)));

  release_path (path);
}

END_TEST
START_TEST (check_remove_part3)
{
  path_t path = root_path ();
  fail_if (!path);

  path_add (path, "/foo/bar");
  remove_last_path_part (path);
  remove_last_path_part (path);
  remove_last_path_part (path);

  fail_unless (0 == strcmp ("/", path_str (path)));

  release_path (path);
}
END_TEST void
add_path_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("Path");
  tcase_add_test (tc_core, check_root);
  tcase_add_test (tc_core, check_append1);
  tcase_add_test (tc_core, check_append2);
  tcase_add_test (tc_core, check_append3);
  tcase_add_test (tc_core, check_append4);
  tcase_add_test (tc_core, check_replace);
  tcase_add_test (tc_core, check_remove_part1);
  tcase_add_test (tc_core, check_remove_part2);
  tcase_add_test (tc_core, check_remove_part3);

  suite_add_tcase (s, tc_core);
}
