/* $Id: check_debugio.h 621 2006-05-10 13:12:58Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>

#include "list.h"
#include "check_list.h"
#include "check_io.h"

START_TEST (check_empty)
{
  list_t list = empty_list ();
  fail_if (!list);
  fail_unless (is_empty_list (list));
  release_list (list);
}
END_TEST

static int
test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 1024 * 1024;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

START_TEST (check_snoc)
{
  const size_t n = test_size ();

  // Create some test data
  size_t *test_data = malloc (sizeof (size_t) * n);
  for (size_t i = 0; i < n; i++)
    test_data[i] = i;

  list_t list = empty_list ();

  const size_t add_size = 3, remove_size = 2;
  size_t added = 0, removed = 0;

  while (removed < n)
    {
      for (size_t i = 0; i < add_size && added < n; i++, added++)
        {
          fail_unless (list_length (list) == added - removed);
          list_snoc (list, &test_data[added]);
          // printf("Added %zu\n", added) ;
        }


      for (size_t i = 0; i < remove_size && removed < n; i++, removed++)
        {
          fail_unless (list_length (list) == added - removed);
          void *data = remove_list_head (list);
          fail_unless (*(size_t *) data == removed);
          // printf("Removed %zu\n", removed) ;
        }
    }

  fail_unless (list_length (list) == added - removed);
  release_list (list);
  free (test_data);
}
END_TEST

void
add_list_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("List");
  tcase_add_test (tc_core, check_empty);
  tcase_add_test (tc_core, check_snoc);
  suite_add_tcase (s, tc_core);
}
