/* $Id: check_datapairstore.c 706 2006-05-27 19:37:17Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "datapairstore.h"

#include "datapairstore.h"
#include "baseio.h"

#include "check_io.h"
#include "check_datapairstore.h"

#define TEST_FILE "/tmp/bumtest.datapairstore.tmp"
#define BUF_SIZE 256
#define SMALL_PAIR_NAME1 "SmallPair1"
#define SMALL_PAIR_DATA1 ""
#define SMALL_PAIR_NAME2 "SmallPair2"
#define SMALL_PAIR_DATA2 "This is the test data for the small pair"

START_TEST (check_basic)
{
  {
    out_stream_t base_outs = baseio_open_out (TEST_FILE, "w");
    fail_if (!base_outs);

    dps_out_t dps_out = open_dps_out (base_outs, 0);
    fail_if (!dps_out);

    fail_unless (output_small_pair
                 (dps_out, SMALL_PAIR_NAME1, SMALL_PAIR_DATA1));
    fail_unless (output_small_pair
                 (dps_out, SMALL_PAIR_NAME2, SMALL_PAIR_DATA2));

    fail_unless (close_dps_out (dps_out));
    // fail_unless (OUTPUT_OK == close_out (base_outs));

    release_dps_out (dps_out);
    // release_out (base_outs);
  }
  mark_point ();
  {
    in_stream_t base_ins = baseio_open_in (TEST_FILE, "r");
    fail_if (!base_ins);
    dps_in_t dps_in = open_dps_in (base_ins, 64, NULL);
    fail_if (!dps_in);


    {
      fail_unless (dps_input_pair (dps_in, NULL));
      const char *input_name = dps_input_pair_name (dps_in);
      fail_if (NULL == input_name);
      if (0 != strcmp (SMALL_PAIR_NAME1, input_name))
        {
          char errbuf[256];
          snprintf (errbuf, 256, "Expected input_name == %s but got %s",
                    SMALL_PAIR_NAME1, input_name);
          fail (errbuf);
        }
      char *buffer;
      fail_if (NULL == (buffer = dps_input_small_data (dps_in)));
      fail_unless (0 == strcmp (SMALL_PAIR_DATA1, buffer));
    }
    {
      fail_unless (dps_input_pair (dps_in, NULL));
      const char *input_name = dps_input_pair_name (dps_in);
      fail_unless (0 == strcmp (SMALL_PAIR_NAME2, input_name));
      char *buffer;
      fail_if (NULL == (buffer = dps_input_small_data (dps_in)));
      fail_unless (0 == strcmp (SMALL_PAIR_DATA2, buffer));
    }

    fail_unless (close_dps_in (dps_in));
    fail_unless (INPUT_OK == close_in (base_ins));

    release_dps_in (dps_in);
    release_in (base_ins);
  }
}

END_TEST
START_TEST (check_long)
{
  {
    out_stream_t base_outs = baseio_open_out (TEST_FILE, "w");
    fail_if (!base_outs);

    dps_out_t dps_out = open_dps_out (base_outs, 0);
    fail_if (!dps_out);

    {
      out_stream_t out_data =
        output_big_pair (dps_out, SMALL_PAIR_NAME1,
                         strlen (SMALL_PAIR_DATA1));
      fail_if (!out_data);
      fail_unless (OUTPUT_OK == close_out (out_data));
      fail_unless (output_end_big_pair (dps_out));
    }
    mark_point ();
    {
      char buf[] = SMALL_PAIR_DATA2;
      const size_t buflen = strlen (buf);
      out_stream_t out_data =
        output_big_pair (dps_out, SMALL_PAIR_NAME2, buflen);
      fail_if (!out_data);
      iobuffer_t iobuf;
      init_iobuffer_with (&iobuf, buflen, buflen, buf);
      fail_unless (OUTPUT_OK == output_all (out_data, &iobuf));
      fail_unless (OUTPUT_OK == close_out (out_data));
      fail_unless (output_end_big_pair (dps_out));
    }

    fail_unless (close_dps_out (dps_out));
    // fail_unless (OUTPUT_OK == close_out (base_outs));

    release_dps_out (dps_out);
    // release_out (base_outs);
  }
  mark_point ();
  {
    in_stream_t base_ins = baseio_open_in (TEST_FILE, "r");
    fail_if (!base_ins);
    dps_in_t dps_in = open_dps_in (base_ins, 64, NULL);
    fail_if (!dps_in);


    {
      fail_unless (dps_input_pair (dps_in, NULL));

      const char *input_name = dps_input_pair_name (dps_in);
      fail_unless (0 == strcmp (SMALL_PAIR_NAME1, input_name));

      in_stream_t in_data = dps_input_big_data (dps_in);
      fail_if (!in_data);
      size_t in_size = dps_input_data_size (dps_in);
      assert (in_size == strlen (SMALL_PAIR_DATA1));
      if (in_size > 0)
        {
          char buffer[in_size];
          iobuffer_t iobuf;
          init_iobuffer_with (&iobuf, in_size, 0, buffer);
          fail_unless_in_status (INPUT_OK, input_all (in_data, &iobuf));

          fail_unless (0 ==
                       strncmp (SMALL_PAIR_DATA1,
                                iobuffer_data_pointer (&iobuf), in_size));
        }
      fail_unless (dps_finish_big_input (dps_in));
    }
    mark_point ();
    {
      fail_unless (dps_input_pair (dps_in, NULL));

      const char *input_name = dps_input_pair_name (dps_in);
      fail_unless (0 == strcmp (SMALL_PAIR_NAME2, input_name));

      in_stream_t in_data = dps_input_big_data (dps_in);
      fail_if (!in_data);
      size_t in_size = dps_input_data_size (dps_in);
      assert (in_size == strlen (SMALL_PAIR_DATA2));
      if (in_size > 0)
        {
          char buffer[in_size];
          iobuffer_t iobuf;
          init_iobuffer_with (&iobuf, in_size, 0, buffer);
          fail_unless_in_status (INPUT_OK, input_all (in_data, &iobuf));

          fail_unless (0 ==
                       strncmp (SMALL_PAIR_DATA2,
                                iobuffer_data_pointer (&iobuf), in_size));
        }
      fail_unless (dps_finish_big_input (dps_in));
    }

    fail_unless (close_dps_in (dps_in));
    fail_unless (INPUT_OK == close_in (base_ins));

    release_dps_in (dps_in);
    release_in (base_ins);
  }
}
END_TEST void
add_datapairstore_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("DatapairStore");
  tcase_add_test (tc_core, check_basic);
  tcase_add_test (tc_core, check_long);
  suite_add_tcase (s, tc_core);
}
