/* $Id: check_stringio.h 621 2006-05-10 13:12:58Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "darray.h"

#include "check_darray.h"

START_TEST (check_alloc)
{
  int *darray = create_darray (sizeof (int), 10, 0);
  fail_if (!darray);
  release_darray (darray);
}

END_TEST
START_TEST (check_size)
{
  int *darray = create_darray (sizeof (int), 10, 0);
  fail_if (!darray);
  fail_unless (0 == darray_size (darray));
  darray = darray_set_size (darray, 5);
  fail_if (!darray);
  fail_unless (5 == darray_size (darray));
  darray = darray_adjust_size (darray, 10);
  fail_if (!darray);
  fail_unless (15 == darray_size (darray));
  release_darray (darray);
}

END_TEST
START_TEST (check_subscript)
{
  int *darray = create_darray (sizeof (int), 10, 0);
  fail_if (!darray);
  fail_unless (0 == darray_size (darray));
  darray = darray_set_size (darray, 10);
  fail_if (!darray);

  for (int i = 0; i < 10; i++)
    darray[i] = i;

  darray = darray_adjust_size (darray, 10);
  for (int i = 10; i < 20; i++)
    darray[i] = i;

  for (int i = 0; i < 10; i++)
    fail_unless (i == darray[i]);

  release_darray (darray);
}

END_TEST
START_TEST (check_add)
{
  int *darray = create_darray (sizeof (int), 10, 0);
  fail_if (!darray);
  fail_unless (0 == darray_size (darray));
  for (int i = 0; i < 20; i++)
    darray = darray_add (darray, &i);

  for (int i = 0; i < 20; i++)
    fail_unless (i == darray[i]);
}
END_TEST void
add_darray_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("DArray");
  tcase_add_test (tc_core, check_alloc);
  tcase_add_test (tc_core, check_size);
  tcase_add_test (tc_core, check_subscript);
  tcase_add_test (tc_core, check_add);
  suite_add_tcase (s, tc_core);
}
