/* $Id: terminatedint.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/*
 * Self terminating ints.  An int is stored in little-endian format.  7 bits of
 * each byte output encode the int itself.  The highest bit of each byte is 1
 * if there are more bytes in the encoding of this int, or 0 if this is the
 * last byte in the encoding.
 *
 * This allows for fairly efficient representation in situations when the value
 * output is usually small, but occasionally large.
 */

#ifndef TERMINATED_INT
#define TERMINATED_INT

#include <stdlib.h>
#include <stdbool.h>
#include <inttypes.h>

#define UINT32_MAX_BYTES 5
#define UINT64_MAX_BYTES 10

/* Encode the given uint32 to the given string, which must be at least
 * UINT32_MAX_BYTES.  Return the number of bytes encoded.
 * The terminating '\0' is not added to the string. */
size_t encode_uint32 (char *dst, uint32_t x);

/* Decode an uint32 from the given string.  The size parameter controls the
 * maximum  number of bytes that will be read from the string.  The result is
 * stored at the location pointed to by result.  Return true if the value is
 * sucessfully decoded, false otherwise (if the string does not represent a
 * valid value) */
bool decode_uint32 (const char *src, size_t, uint32_t * result);

/* Encode a byte of x to dst.  Return true iff there are more bytes to output.
 * The argument x is modified so that it is suitable for the next call to
 * this function. */
bool encode_uint32_byte (char *dst, uint32_t * x);

/* Decode a byte from src into x.  pos is the number of bytes input so far.
 * Return true iff there are more bytes to input. */
bool decode_uint32_byte (uint32_t * a, int pos, const char *src);

/* As above, but for uint64_t values. */
size_t encode_uint64 (char *dst, uint64_t x);
bool decode_uint64 (const char *src, size_t, uint64_t * result);
bool encode_uint64_byte (char *dst, uint64_t * x);
bool decode_uint64_byte (uint64_t * a, int pos, const char *src);

#endif
