/* $Id: statio.h 695 2006-05-20 01:30:20Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef STATIO_H
#define STATIO_H

#include <stdlib.h>
#include <time.h>
#include "nonstdio.h"
#include "path.h"

typedef struct
{
  time_t stats_created;
  path_t stats_path;
  off_t stats_bytes_written;
  off_t stats_bytes_read;
  size_t stats_output_marks;
  size_t stats_input_marks;
  size_t stats_open_outs;
  size_t stats_open_ins;
  size_t stats_close_outs;
  size_t stats_close_ins;
  size_t stats_output_outcome[OUTPUT_ERR_COUNT];
  size_t stats_input_outcome[INPUT_ERR_COUNT];
} iostat_t;

/* Create a structure to hold stats. */
iostat_t *create_stats (void);

/* Clear stats in the given structure. */
void clear_stats (iostat_t *);

/* Release a structure allocated with create_stats. */
void release_stats (iostat_t *);

/* Open a stat recording output stream. */
out_stream_t statio_open_out (out_stream_t, iostat_t *, bool, bool);

/* Open a stat recording input stream. */
in_stream_t statio_open_in (in_stream_t, iostat_t *, bool, bool);

void merge_stats_path(iostat_t *stats, path_t path);
void clear_stats_path(iostat_t *stats);

#endif
