/* $Id: sha1sumio.c 658 2006-05-13 14:50:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "checksumio.h"
#include "sha1sumio.h"

#define SHA1SUM_PATH "/usr/bin/sha1sum"

out_stream_t
sha1sumio_open_out (out_stream_t base, bool own_base, char *buffer)
{
  return checksumio_open_out (base, own_base,
                              SHA1SUM_PATH, true, buffer, SHA1_SUM_LEN);
}

in_stream_t
sha1sumio_open_in (in_stream_t base, bool own_base, char *buffer)
{
  return checksumio_open_in (base, own_base,
                             SHA1SUM_PATH, true, buffer, SHA1_SUM_LEN);
}
