/* $Id: path.h 695 2006-05-20 01:30:20Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef PATH_H
#define PATH_H

#include <stdbool.h>
#include <stdlib.h>

typedef struct path *path_t;
path_t root_path (void);
path_t current_dir (void);
path_t make_path (const char *);
void path_add (path_t path, const char *part);
void release_path (path_t path);
const char *path_str (path_t path);
path_t copy_path (const path_t path);
void remove_last_path_part (path_t path);
void set_path_length (path_t, size_t);

#endif
