/* $Id: nomarkio.c 658 2006-05-13 14:50:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <assert.h>

#include "logging.h"
#include "nomarkio.h"

struct nomark_in_data
{
  in_stream_t in_base;
  bool in_own_base;
};

static input_err_t
my_input_limited (void *uncast_data, iobuffer_t * buf, size_t amount)
{
  struct nomark_in_data *data = (struct nomark_in_data *) uncast_data;
  if (!data)
    return INPUT_ERR_BAD;

  input_err_t err;
  while (INPUT_MARK == (err = input_limited (data->in_base, buf, amount)))
    {
      DEBUG ("Ignoring mark");
      if (INPUT_OK != (err = input_mark (data->in_base)))
        break;
    }

  return err;
}

static input_err_t
my_input_recover (void *uncast_data)
{
  struct nomark_in_data *data = (struct nomark_in_data *) uncast_data;
  if (!data)
    return INPUT_ERR_BAD;

  DEBUG ("Error recovery");

  return input_recover (data->in_base);
}

static input_err_t
my_close_in (void *uncast_data)
{
  struct nomark_in_data *data = (struct nomark_in_data *) uncast_data;
  if (!data)
    return INPUT_ERR_BAD;

  return close_in (data->in_base);
}

static void
my_release_in (void *uncast_data)
{
  struct nomark_in_data *data = (struct nomark_in_data *) uncast_data;
  assert (data);

  if (data->in_own_base)
    release_in (data->in_base);

  free (data);
}

static in_stream_type_t my_in_type = {
  .input_limited = my_input_limited,
  .input_mark = NULL,           // Unimplemented
  .close_in = my_close_in,
  .release_in = my_release_in,
  .input_recover = my_input_recover
};

in_stream_t
nomarkio_open_in (in_stream_t base_ins, bool own_base)
{
  struct nomark_in_data *data = malloc (sizeof (struct nomark_in_data));
  if (!data)
    MEMFAILED ();

  data->in_base = base_ins;
  data->in_own_base = own_base;

  return open_in (&my_in_type, data);
}
