/* $Id: logging.h 700 2006-05-21 20:45:21Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef LOGGING_H
#define LOGGING_H

#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>

typedef enum
{ DEBUG, VERBOSE, NORMAL, WARNING, ERROR, FATAL } loglev_t;

extern FILE *logging_log_file;

extern loglev_t logging_log_lev;

#define LOG_MAX_PREFIX 256
extern char log_prefix[LOG_MAX_PREFIX];

extern unsigned logging_erase_chars;

#define ERASE_OLD() { if (logging_erase_chars > 0) { for (int i = 0; i < logging_erase_chars; i++) fputc(' ', logging_log_file); logging_erase_chars = 0; fputc('\r', logging_log_file); } }

#define LOG(level, format) { if(level >= logging_log_lev) { ERASE_OLD(); fputs(log_prefix, logging_log_file) ; fputs(format "\n", logging_log_file) ; fflush(logging_log_file) ; } }

#define LOGF(level, format, ...) { if(level >= logging_log_lev) { ERASE_OLD(); fputs(log_prefix, logging_log_file) ; fprintf(logging_log_file, format "\n", __VA_ARGS__) ; fflush(logging_log_file) ; } }

#define TLOGF(level, format, ...) { if(level >= logging_log_lev) { ERASE_OLD(); fputs(log_prefix, logging_log_file) ; logging_erase_chars = strlen (log_prefix) + fprintf(logging_log_file, format "\r", __VA_ARGS__) ; fflush(logging_log_file) ; } }

#ifdef NDEBUG
/* Debugging is disabled */

#define DEBUG(format) 0
#define DEBUGF(format, ...) 0
#define IS_DEBUG_ENABLED() false

#else
/* Debugging is enabled */

#define DEBUG(format) { if(DEBUG >= logging_log_lev) { fputs(log_prefix, logging_log_file) ; fprintf(logging_log_file, format " (%s:%d)\n", __FILE__, __LINE__) ; fflush(logging_log_file) ; } }
#define DEBUGF(format, ...) { if(DEBUG >= logging_log_lev) { fputs(log_prefix, logging_log_file) ; fprintf(logging_log_file, format " (%s:%d)\n", __VA_ARGS__, __FILE__, __LINE__) ; fflush(logging_log_file) ; } }

#define IS_DEBUG_ENABLED() (DEBUG >= logging_log_lev)

#endif

#define IS_VERBOSE_ENABLED() (VERBOSE >= logging_log_lev)
#define IS_NORMAL_ENABLED() (NORMAL >= logging_log_lev)

#define FATAL(err) { LOG(FATAL, err) ; abort() ; }
#define MEMFAILED() FATAL("Fatal: Out of memory")

void init_logging (FILE *, loglev_t);

void set_logging_prefix (const char *pfix);

#endif
