/* $Id: logging.c 700 2006-05-21 20:45:21Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <string.h>
#include "logging.h"

FILE *logging_log_file;

loglev_t logging_log_lev;

char log_prefix[LOG_MAX_PREFIX];

unsigned logging_erase_chars = 0;

void
init_logging (FILE * log_file, loglev_t log_lev)
{
  logging_log_file = log_file;
  logging_log_lev = log_lev;

  log_prefix[0] = '\0';

  LOG (DEBUG, "Logging initialized");
}

void
set_logging_prefix (const char *pfix)
{
  strncpy (log_prefix, pfix, LOG_MAX_PREFIX);
}
