/* $Id: gpgio.c 697 2006-05-21 18:44:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdio.h>
#include <assert.h>
#include <fcntl.h>
#include <unistd.h>

#include "logging.h"
#include "commandfilterio.h"
#include "gpgio.h"

#define PASSPHRASE_ARG "--passphrase-fd"

static bool
fix_args (void *uncast_data, args_t argv, args_t env)
{
  int fd = open ((char *) uncast_data, O_RDONLY);
  if (-1 == fd)
    {
      LOGF(ERROR, "Couldn't open file: %s", (char *)uncast_data);
      return false;
    }

  assert (fd > 0);

  for (int i = 0; NULL != argv[i]; i++)
    {
      if (0 == strcmp (PASSPHRASE_ARG, argv[i]))
        {
          const int pp = i + 1;
          if (!argv[pp])
            return false;
          sprintf (argv[pp], "%d", fd);
          return true;
        }
    }

  return false;
}

out_stream_t
gpgio_open_out (out_stream_t base_outs, const char *passphrase, bool own_base)
{

  char *argv[] = {
    "/usr/bin/gpg",
    "--symmetric",
    PASSPHRASE_ARG, "    ",
    "--compress-algo", "none",
    "--cipher-algo", "twofish",
    "--batch",
    "--no-options",
    "--quiet",
    NULL
  };

  return commandfilter_open_out ("/usr/bin/gpg", 4096, argv, NULL, fix_args,
                                 (void *) passphrase, base_outs, own_base);
}

in_stream_t
gpgio_open_in (in_stream_t base_ins, const char *passphrase, bool own_base)
{
  char *argv[] = {
    "/usr/bin/gpg",
    "--decrypt",
    PASSPHRASE_ARG, "    ",
    "--batch",
    "--no-options",
    "--no-mdc-warning",
    "--quiet",
    NULL
  };

  return commandfilter_open_in ("/usr/bin/gpg", 4096, argv, NULL, fix_args,
                                (void *) passphrase, base_ins, own_base);
}
