/* $Id: fixedlenio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef FIXEDLENIO_H
#define FIXEDLENIO_H

/**
 * Create file handles which read from, or write to, a fixed length portion of
 * the underlying stream.  Attempts to read or write past this length on the
 * overlying stream will fail.  If the overlying stream is closed before the
 * fixed length has been read or written, the remaining bytes in the underlying
 * stream are skipped, or written with padding.
 */

#include "nonstdio.h"

out_stream_t fixedlenio_open_out (out_stream_t, off_t);
in_stream_t fixedlenio_open_in (in_stream_t, off_t);

#endif
