/* $Id: filestore_input.h 709 2006-05-28 20:50:21Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef FILESTORE_INPUT_H
#define FILESTORE_INPUT_H

#include "statio.h"
#include "path.h"
#include "list.h"
#include "filelib.h"

#include "filestore_stats.h"

typedef struct
{
  filestore_stats_t *fip_filestore_stats;
  iostat_t          *fip_iostats;
  in_stream_t       fip_in_stream;
  char              *fip_gpg_passphrase;  // passphrase filename for
                                          // encryption, or NULL to disable (default: NULL)
  bool              fip_gzip;     // true to enable gzip compression (default: false)
  bool              fip_bzip2;    // true to enable bzip2 compression (default: false)
  bool              fip_sha1sum;  // true to enable SHA1 checksums (default: false)
  bool              fip_md5sum;   // true to enable MD5 checksums (default: false)
  bool              fip_ignore_header;
  list_t            fip_regexs;
} filestore_in_params_t;

typedef struct filestore_in *filestore_in_t;

void init_filestore_in_params (filestore_in_params_t *params, in_stream_t in_stream);

/* Open a filestore for input. */
filestore_in_t open_filestore_in (filestore_in_params_t *params);

/* Close an input filestore. */
bool close_filestore_in (filestore_in_t);

/* Release resources associated with a filestore. */
void release_filestore_in (filestore_in_t);

/* Verify the contents of a filestore against the filesystem.  The callback is
 * called after each file (it can be used, for example for reporting stats).
 * The path is the prefix to add to paths in the archive (so they point to file
 * on the local disk).
 */
bool filestore_verify_in (filestore_in_t, filestore_stats_t *, path_t,
                          void (*file_callback) (void *, path_t),
                          void *callback_data);

/* Check the integrety of the archive. */
bool filestore_check_in (filestore_in_t, filestore_stats_t *, path_t,
                         void (*file_callback) (void *, path_t),
                         void *callback_data);

/* Extract the contents of an archive. */
bool filestore_extract_in (filestore_in_t, filestore_stats_t *, path_t,
                           void (*file_callback) (void *, path_t),
                           void *callback_data);

/* Extract the contents of an archive. */
bool filestore_identify_in (filestore_in_t, filestore_stats_t *);

#endif
