/* $Id: checksumio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * Input and output streams which compute checksums using external programs
 * like md5sum and sha1sum.  A buffer is supplied when opening the stream.
 * When the stream is closed, this buffer will be filled with the checksum
 * computed by the program.
 */

#ifndef CHECKSUMIO_H
#define CHECKSUMIO_H

#include "nonstdio.h"

out_stream_t checksumio_open_out (out_stream_t, bool own_base,
                                  const char *path, bool bin_opt,
                                  char *buffer, size_t buffer_len);

in_stream_t checksumio_open_in (in_stream_t, bool own_base,
                                const char *path, bool bin_opt,
                                char *buffer, size_t buffer_len);

#endif
