/* $Id: checksumio.c 691 2006-05-19 08:45:48Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <assert.h>

#include "commandfilterio.h"
#include "stringio.h"
#include "teeio.h"
#include "checksumio.h"

out_stream_t
checksumio_open_out (out_stream_t base, bool own_base,
                     const char *path, bool bin_opt,
                     char *buffer, size_t buffer_len)
{

  // Open out channel on the buffer
  for (int i = 0; i < buffer_len; i++)
    buffer[i] = '\0';

  out_stream_t string_out =
    stringio_open_out (buffer, buffer_len - 1, NULL, true, false);

  if (!string_out)
    return NULL;

  char *argv[] = {
    (char *) path,
    NULL,
    NULL
  };

  if (bin_opt)
    argv[1] = "-b";

  // Open checksum out channel
  out_stream_t checksum_out =
    commandfilter_open_out (path, 4096, argv, NULL, NULL, NULL, string_out,
                            true);
  if (!checksum_out)
    {
      close_and_release_out (string_out);
      return NULL;
    }

  // Connect to base with T-join
  out_stream_t outs = teeio_open_out (base, own_base, checksum_out, true);
  if (!outs)
    {
      close_and_release_out (checksum_out);
      return NULL;
    }

  return outs;
}

in_stream_t
checksumio_open_in (in_stream_t base, bool own_base,
                    const char *path, bool bin_opt,
                    char *buffer, size_t buffer_len)
{
  // Open out channel on the buffer
  for (int i = 0; i < buffer_len; i++)
    buffer[i] = '\0';

  out_stream_t string_out =
    stringio_open_out (buffer, buffer_len - 1, NULL, true, false);

  if (!string_out)
    return NULL;

  char *argv[] = {
    (char *) path,
    NULL,
    NULL
  };

  if (bin_opt)
    argv[1] = "-b";

  // Open checksum out channel
  out_stream_t checksum_out =
    commandfilter_open_out (path, 4096, argv, NULL, NULL, NULL, string_out,
                            true);
  if (!checksum_out)
    {
      close_and_release_out (string_out);
      return NULL;
    }

  // Connect to base with T-join
  in_stream_t ins = teeio_open_in (base, own_base, checksum_out, true);
  if (!ins)
    {
      close_and_release_out (checksum_out);
      return NULL;
    }

  return ins;
}
