/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SURFACE_H_
#define _SURFACE_H_

#include <GL/gl.h>
#include "node.h"

@interface Surface: Node {
    GLuint program, vertex, fragment;

    struct {
	GLint sourcePositions[8];
	GLint sourceConstants[8];
	GLint sourceAttenuations[8];
	GLint sourceOrientations[8];
	GLint sourceFlags[8];
	GLint sourceMaps[8];
	
	GLint shadowMatrices[8];
	GLint shadowMaps[8];

	GLint fogOffset, fogDensity, fogColor;
	GLint ambienceFrame, ambienceMap, ambienceConstant;

	int lightCount;
	int hasAmbience, hasFog;
    } surface;
}

-(void)build;
-(void)attachVertexSource: (const GLchar *)source;
-(void)attachFragmentSource: (const GLchar *)source;
-(void)link;
-(void)verify;

@end

#endif
