/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PISTON_H_
#define _PISTON_H_

#include <lua.h>
#include <ode/ode.h>
#include "transform.h"

@interface Piston: Transform {
    double output, speed, diameter, inertia;
    double throttle, bypass, idle, rating[2], ratio;
    
    struct {
	int length;
	double *values;
    } coefficients[2], brakepower;
}

@end

#endif
