/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>

static int fromunsignedbytes (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushunsignedbytes (L);

    return 1;
}

static int frombytes (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushbytes (L);

    return 1;
}

static int fromunsignedchars (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushunsignedchars (L);

    return 1;
}

static int fromchars (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushchars (L);

    return 1;
}

static int fromunsignedshorts (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushunsignedshorts (L);

    return 1;
}

static int fromshorts (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushshorts (L);

    return 1;
}

static int fromunsignedints (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushunsignedints (L);

    return 1;
}

static int fromints (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushints (L);

    return 1;
}

static int fromfloats (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushfloats (L);

    return 1;
}

static int fromdoubles (lua_State *L)
{
    luaL_checkstring (L, 1);
    
    luaX_pushdoubles (L);

    return 1;
}

int luaopen_pack (lua_State *L)
{
    const luaL_Reg pack[] = {
	{"fromdoubles", fromdoubles},
	{"fromfloats", fromfloats},
	{"fromshorts", fromshorts},
	{"fromunsignedshorts", fromunsignedshorts},
	{"fromints", fromints},
	{"fromunsignedints", fromunsignedints},
	{"fromchars", fromchars},
	{"fromunsignedchars", fromunsignedchars},
	{"frombytes", frombytes},
	{"fromunsignedbytes", fromunsignedbytes},
	{NULL, NULL}
    };

    luaL_register (L, "pack", pack);

    return 0;
}
