/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "gauge.h"

@implementation Gauge

-(Gauge *)init
{
    char *list[] = {
	"radius", "range", "reading", "spacing", "spread",
	"thickness"
    };

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->radius[0] = 0.1;
    self->radius[1] = 0.07;
    
    self->thickness = 1;

    self->range[0] = 0;
    self->range[1] = 100;

    self->spread[0] = -3 * M_PI / 5;
    self->spread[1] = 3 * M_PI / 5;

    self->spacing[0] = 1;
    self->spacing[1] = 5;

    self->size = 0;
    self->reading = NULL;
    
    return self;
}

-(double) measureWidth
{
    self->minimum[0] = 2 * (self->padding[0] + self->radius[0]);

    return self->minimum[0];
}

-(double) measureHeight
{
    self->minimum[1] = 2 * (self->padding[1] + self->radius[0]);

    return self->minimum[1];
}

-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "radius")) {
	lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->radius[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } if (!xstrcmp(k, "thickness")) {
	lua_pushnumber (_L, self->thickness);
    } else if (!xstrcmp(k, "reading")) {
	if (self->size == 0) {
	    lua_pushnil (_L);
	} else if (self->size == 1) {
	    lua_pushnumber (_L, self->reading[0]);
	} else {
	    lua_newtable (_L);

	    for (i = 0 ; i < self->size ; i += 1) {
		lua_pushnumber (_L, self->reading[i]);
		lua_rawseti (_L, -2, i + 1);
	    }
	}
    } else if (!xstrcmp(k, "range")) {
	lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->range[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "spacing")) {
	lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->spacing[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "spread")) {
	lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->spread[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "radius")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->radius[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } if (!xstrcmp(k, "thickness")) {
	self->thickness = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "reading")) {
	if (lua_isnumber (_L, 3)) {

	    if (self->size < 1) {
		self->reading = realloc (self->reading, sizeof(double));
		self->size = 1;
	    }
	    
	    self->reading[0] = lua_tonumber (_L, 3);
	} else if (lua_istable (_L, 3)) {
	    int n;

	    n = lua_objlen (_L, 3);

	    if (n > self->size) {
		self->reading = realloc (self->reading, n * sizeof(double));
		self->size = n;
	    }
	    
	    for (i = 0 ; i < n ; i += 1) {
		lua_rawgeti (_L, -1, i + 1);
		self->reading[i] = lua_tonumber (_L, -1);
		lua_pop (_L, 1);
	    }
	}
    } else if (!xstrcmp(k, "range")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->range[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "spacing")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->spacing[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "spread")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->spread[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else {
	[super set];
    }
}

@end
