/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <GL/glu.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "capsule.h"

@implementation Capsule

-(Capsule *) init
{
    char *list[] = {"length", "radius"};

    self->quadric = gluNewQuadric();
    gluQuadricDrawStyle(self->quadric, GLU_LINE);
    gluQuadricNormals(self->quadric, GLU_NONE);

    self->geom = dCreateCapsule (NULL, 1, 1);
    dGeomSetData (self->geom, self);

    self->radius = 1;
    self->length = 1;
    
    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    return self;
}

-(dReal) radius
{
    return self->radius;
}

-(dReal) length
{
    return self->length;
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "radius")) {
	lua_pushnumber (_L, [self radius]);
    } else if (!xstrcmp(k, "length")) {
	lua_pushnumber (_L, [self length]);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "radius")) {
	radius = lua_tonumber (_L, 3);

	dGeomCapsuleSetParams ([self geom], [self radius], [self length]);
    } else if (!xstrcmp(k, "length")) {
	length = lua_tonumber (_L, 3);

	dGeomCapsuleSetParams ([self geom], [self radius], [self length]);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    if (pass == 1 && self->debug) {
	glUseProgramObjectARB(0);

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glMultMatrixd ([self matrix]);

	glLineWidth (1);

	glEnable (GL_DEPTH_TEST);

	glColor3f (0, 1, 0);
	glBegin (GL_LINES);
	glVertex3f (0, 0, -0.5 * self->length - self->radius);
	glVertex3f (0, 0, 0.5 * self->length + self->radius);
	glEnd();
    
	glTranslatef (0, 0, -0.5 * self->length);

	glColor3f (1, 0, 0);
	gluCylinder (self->quadric, self->radius, self->radius,
		     self->length, 16, 1);
    
	glDisable (GL_DEPTH_TEST);

	glPopMatrix();
    }
    
    [super traversePass: pass];
}

@end
