-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "pack"

network.mime["/buffers/color"] = "image/png"
network.pages["/buffers/color"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.flip (graphics.colorbuffer, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/buffers/depth"] = "image/png"
network.pages["/buffers/depth"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.autolevel (graphics.depthbuffer, w, h)
      image = imaging.flip (image, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/buffers/stencil"] = "image/png"
network.pages["/buffers/stencil"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.autolevel (graphics.stencilbuffer, w, h)
      image = imaging.flip (image, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/console"] = "text/plain"
network.pages["/console"] =
   function (method, uri, version)
      return io.stdout:read("*a")
   end
