/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "shape.h"

@implementation Shape

-(Shape *)init
{
    char *list[] = {
	"color", "endpoint", "opacity", "width"
    };

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->vertices = NULL;
    self->size = 0;

    self->width = 1;

    self->color[0] = 1;
    self->color[1] = 1;
    self->color[2] = 1;
    self->color[3] = 1;

    self->factor = 1;
    self->pattern = 0xffff;

    return self;
}

-(int) size
{
    return self->size;
}

-(void) get
{
    const char *k;
    int i, j;

    k = lua_tostring (_L, 2);

    if (lua_isnumber (_L, 2)) {
	j = lua_tonumber (_L, 2) - 1;
	
	lua_newtable (_L);

        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->vertices[3 * j + i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "width")) {
	lua_pushnumber (_L, self->width);
    } else if (!xstrcmp(k, "opacity")) {
	lua_pushnumber (_L, self->color[3]);
    } else if (!xstrcmp(k, "stipple")) {
	lua_newtable (_L);
	lua_pushnumber (_L, self->factor);
	lua_rawseti (_L, -2, 1);
	lua_pushinteger (_L, self->pattern);
	lua_rawseti (_L, -2, 2);
    } else if (!xstrcmp(k, "endpoint")) {
	lua_pushnumber (_L, self->size);
	lua_replace (_L, 2);
	lua_gettable (_L, 1);
    } else if (!xstrcmp(k, "color")) {
	lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->color[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;
    int i, j;

    k = lua_tostring (_L, 2);

    if (lua_isnumber (_L, 2)) {
        if(lua_istable (_L, 3)) {
	    j = lua_tonumber (_L, 2);

	    if (j > self->size) {
		self->size = j;
		self->vertices = (GLfloat *)realloc (self->vertices,
						     3 * j * sizeof(GLfloat));
	    }

            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->vertices[3 * (j - 1) + i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "stipple")) {
        if(lua_istable (_L, 3)) {
	    lua_rawgeti (_L, 3, 1);
	    self->factor = lua_tonumber (_L, -1);
	    lua_pop (_L, 1);
	    
	    lua_rawgeti (_L, 3, 2);
	    self->pattern = lua_tointeger (_L, -1);
	    lua_pop (_L, 1);
	} else {
	    self->pattern = 0xffff;
	}
    } else if (!xstrcmp(k, "width")) {
	self->width = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "opacity")) {
	self->color[3] = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "endpoint")) {
	lua_pushnumber (_L, self->size + 1);
	lua_replace (_L, 2);
	lua_settable (_L, 1);
    } else if (!xstrcmp(k, "color")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->color[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else {
	[super set];
    }
}

-(void) free
{
    if (self->vertices) {
	free (self->vertices);
    }

    [super free];
}

@end
