/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "texture.h"
#include "prototype.h"
#include "light.h"

static GLuint name;
static const GLchar *vertexSource =
"varying vec3 vertexNormal, vertex;  		      		   	   \n"
"				   		     			   \n"
"void main() 			   		     			   \n"
"{		 		   		     			   \n"
"    vertexNormal = gl_NormalMatrix * gl_Normal;			   \n"
"    vertex = vec3(gl_ModelViewMatrix * gl_Vertex);			   \n"
"				   		     			   \n"
"    gl_Position = ftransform();	     				   \n"
"    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;		   \n"
"}		 		   		     			   \n";

static const GLchar *fragmentSource = 
"varying vec3 vertexNormal, vertex;  	     	     		   	   \n"
"				   		     			   \n"
"void main()                            	     			   \n"
"{	                                	     			   \n"
"    vec4 texel;   	   	   \n"
"				   		     			   \n"
"    texel = texture2D(diffuseSampler, gl_TexCoord[0].st); \n"
"    //if (texel.a < 0.01) {discard;}   		     			   \n"
"    gl_FragColor = gl_Color * texel;	   \n"
"}                                      	     			   \n";

@implementation Prototype

-(Prototype *)init
{
    if (!name) {
	[self build];
	[self verify];

	name = self->program;
    } else {
	self->program = name;
    }

    [super init];
    
    return self;
}

-(void) build
{
    [super build];
    
    [self attachVertexSource: vertexSource];
    [self attachFragmentSource: fragmentSource];
    [self link];
}
    
-(void) traversePass: (int)pass
{
    if (pass == 2) {
	glUseProgramObjectARB(self->program);
	glActiveTexture (GL_TEXTURE0);

	glDepthMask (GL_FALSE);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glEnable (GL_BLEND);
   
	[super traversePass: pass];

	glDepthMask (GL_TRUE);

	glDisable (GL_BLEND);
    } else {
	[super traversePass: pass];
    }
}

@end
