/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "polygon.h"

@implementation Polygon

-(void) traversePass: (int)pass
{
    if (pass == 2) {
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glMultMatrixd ([self matrix]);

	glUseProgramObjectARB(0);

	/* if (self->pattern != 0xffff) { */
	/*     glLineStipple(self->factor, self->pattern); */
	/*     glEnable (GL_LINE_STIPPLE); */
	/* } */
	
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_POLYGON_SMOOTH);
	glEnable(GL_BLEND);
	glDepthMask (GL_FALSE);

	glColor4dv(self->color);

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, self->vertices);
	glDrawArrays(GL_POLYGON, 0, self->size);
	glDisableClientState(GL_VERTEX_ARRAY);
    
	glDepthMask (GL_TRUE);
	glDisable(GL_BLEND);
	glDisable(GL_POLYGON_SMOOTH);
	glDisable(GL_DEPTH_TEST);
    
	glMatrixMode (GL_MODELVIEW);
	glPopMatrix();
    }
    
    [super traversePass: pass];
}

@end
