/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include "meta.h"

static void callmetahooks (lua_State *L, void *key, int reference)
{
    int h;
    
    if (reference != LUA_REFNIL) {
	h = lua_gettop (L);
	
	lua_rawgeti(L, LUA_REGISTRYINDEX, reference);
	    
	if (lua_isfunction (L, -1)) {
	    lua_getfield (L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (L, key);
	    lua_gettable (L, -2);
	    lua_replace (L, -2);
	    
	    lua_pushvalue (L, 2);
	    lua_pushvalue (L, 3);
	    luaX_call(L, 3, LUA_MULTRET);
	} else if (lua_istable (L, -1)) {
	    int i, n;
	    
	    n = lua_objlen (L, -1);

	    lua_getfield (L, LUA_REGISTRYINDEX, "userdata");

	    for (i = 0 ; i < n ; i += 1) {
		lua_settop (L, h + 2);
		lua_rawgeti (L, -2, i + 1);

		lua_pushlightuserdata (L, key);
		lua_gettable (L, -3);

		lua_pushvalue (L, 2);
		lua_pushvalue (L, 3);
		luaX_call (L, 3, LUA_MULTRET);
	    }

	    /* Remove the userdata and hook table
	       from the stack. */
	    
	    lua_remove (L, h + 1);
	    lua_remove (L, h + 1);
	} else {
	    lua_pop (L, 1);
	}

	if (lua_gettop (L) > h + 1) {
	    lua_settop (L, h + 1);
	}
    }
}

@implementation Meta

-(Meta *) init
{
    char *list[] = {"get", "set"};
    
    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->get = LUA_REFNIL;    
    self->set = LUA_REFNIL;    
    
    return self;
}

-(void) free
{
    luaL_unref (_L, LUA_REGISTRYINDEX, self->get);
    luaL_unref (_L, LUA_REGISTRYINDEX, self->set);

    [super free];
}

-(void) get
{
    const char *k;
    int h;

    h = lua_gettop (_L);
    
    callmetahooks (_L, self, self->get);

    if (lua_gettop (_L) == h) {
	k = lua_tostring (_L, 2);

	if (!xstrcmp(k, "get")) {
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->get);
	} else if (!xstrcmp(k, "set")) {
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->set);
	} else {
	    [super get];
	}
    }    
}

-(void) set
{    
    const char *k;
    int h, handled = 0;

    h = lua_gettop (_L);
    
    callmetahooks (_L, self, self->set);

    if (lua_gettop (_L) > h) {
	if (lua_toboolean (_L, -1)) {
	    handled = 1;
	}

	lua_pop (_L, 1);
    }

    if (!handled) {
	k = lua_tostring (_L, 2);

	if (!xstrcmp(k, "get")) {
	    luaL_unref (_L, LUA_REGISTRYINDEX, self->get);
	    self->get = luaL_ref (_L, LUA_REGISTRYINDEX);
	} else if (!xstrcmp(k, "set")) {
	    luaL_unref (_L, LUA_REGISTRYINDEX, self->set);
	    self->set = luaL_ref (_L, LUA_REGISTRYINDEX);
	} else {
	    [super set];	
	}
    }
}

@end
