/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _LIGHT_H_
#define _LIGHT_H_

#include <GL/gl.h>
#include "transform.h"

@interface Light: Transform {
    GLfloat projection[16], modelview[16];
    GLuint buffer;
    
    GLint size[2];
    GLfloat volume[6];
    GLfloat offset[2];
    
    GLfloat attenuation[3];
    
    GLfloat shadowMatrix[16];
    GLuint shadowMap;
    
    GLfloat intensityConstant[3];
    id intensityMap;
}

-(void) loadPositionInto: (unsigned int)this
      andOrientationInto: (unsigned int)that;
-(void) loadIntesityConstantInto: (unsigned int)this
                      andMapInto: (unsigned int)that;
-(void) loadAttenuationInto: (unsigned int)this;
-(void) loadShadowMatrixInto: (unsigned int)this
		  andMapInto: (unsigned int)that
		 andFlagInto: (unsigned int)there;

@end

#endif
