/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <time.h>
#include "lamp.h"

#define N 32

@implementation Lamp

-(Lamp *) init
{
    char *list[] = {"ambience", "intensity"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];
    
    self->intensity = 0;
    
    return self;
}

-(GLfloat) ambience
{
    return self->ambience;
}

-(GLuint) intensity
{
    return self->intensity;
}

-(void) setupTextureUnit
{
    double T[16], M[16] = {0, 0, 0, 0,
			   0, 0, 0, 0,
			   0, 0, 0, 0,
			   0, 0, 0, 1};

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix ();
    glMultMatrixd ([self matrix]);
    glGetDoublev (GL_MODELVIEW_MATRIX, T);
    glPopMatrix();
		    
    M[0] = -T[8];
    M[4] = -T[9];
    M[8] = -T[10];
    M[12] = self->ambience;
		    
    glBindTexture (GL_TEXTURE_1D, self->intensity);

    glMatrixMode (GL_TEXTURE);
    glLoadMatrixd(M);
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else if (!xstrcmp(k, "ambience")) {
	lua_pushnumber (_L, self->ambience);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i, j;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
        if(lua_istable (_L, 3)) {
	    float pixels[3 * N], a, b;
	    GLenum error;
	    int flags[N];

	    for (i = 0 ; i < N ; i += 1) {
		flags[i] = 0;
	    }
	    
	    lua_pushnil(_L);
	    while (lua_next(_L, 3) != 0) {
		a = lua_tonumber (_L, -2);
		b = flags [(int)(a * N)];
		
		for (i = (int)(a * N) ; i < N && flags[i] == b ; i += 1) {
		    if (lua_isnumber (_L, -1)) {
			pixels[3 * i] = lua_tonumber (_L, -1);
			pixels[3 * i + 1] = lua_tonumber (_L, -1);
			pixels[3 * i + 2] = lua_tonumber (_L, -1);
		    } else if (lua_istable (_L, -1)) {
			for (j = 0 ; j < 3 ; j += 1) {
			    lua_rawgeti (_L, -1, j + 1);
			    pixels[3 * i + j] = lua_tonumber (_L, -1);
			    lua_pop (_L, 1);
			}
		    }

		    flags[i] += 1;
		}
		
		lua_pop(_L, 1);
	    }
	    
	    glGetError();
	    glDeleteTextures (1, &self->intensity);
	    glGenTextures(1, &self->intensity);
	    glBindTexture(GL_TEXTURE_1D, self->intensity);
    
	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_CLAMP);

	    glTexImage1D (GL_TEXTURE_1D,
			  0,
			  GL_RGB, N, 0,
			  GL_RGB,
			  GL_FLOAT,
			  pixels);
		
	    error = glGetError();
	    if(error != GL_NO_ERROR) {
		printf ("Could not create cel texture (%s)\n",
			(char *)gluErrorString(error));
		abort();
	    }
        }
    } else if (!xstrcmp(k, "ambience")) {
	self->ambience = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

@end

