/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <ode/ode.h>
#include "heightfield.h"

@implementation Heightfield

-(Heightfield *) init
{
    self->geom = dCreateHeightfield (NULL, self->data, 1);
    dGeomSetData (self->geom, self);
  
    [super init];

    return self;
}

-(void) freeData
{
    dGeomHeightfieldDataDestroy (self->data);
}

-(Heightfield *) initWithFloats: (float *) floats
                         ofSize: (int[2]) size
		       spanning: (float[2]) area
		       scaledBy: (float) scale
		       offsetBy: (float) offset
		       andThickenedBy: (float) thickness
{
    [super init];

    self->data = dGeomHeightfieldDataCreate();
    dGeomHeightfieldDataBuildSingle (self->data,
				     floats,
				     1,
				     area[0], area[1],
				     size[0], size[1],
				     scale, offset,
				     thickness,
				     0);

    self->width = size[0];
    self->height = size[1];
    
    return self;
}

-(int) width
{
    return self->width;
}

-(int) height
{
    return self->height;
}

-(dHeightfieldDataID) data
{
    return self->data;
}

@end
