/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <GL/glu.h>
#include "blur.h"

@implementation Blur

-(Blur *) init
{
    self = [super init];
    
    return self;
}

-(void) toggle
{
    [super toggle];
    
    if (self->linked) {
	glClearAccum(0.0, 0.0, 0.0, 1.0);
	glClear(GL_ACCUM_BUFFER_BIT);
    }
}
    
-(void) finish
{
    [super finish];

    if (self->progress > 0) {
	glAccum(GL_MULT, self->progress);
	glAccum(GL_ACCUM, 1 - self->progress);
	glAccum(GL_RETURN, 1);
    }
}

@end
