-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "resources"
require "imaging"

common.iterate = false

assert (options.input, "No input file given.\n")

if options.input then
   local input = resources.dofile (options.input)
   local file

   print ("")

   assert (type(input) == "table",
	   "The input file does not appear to be anything convertible.\nSorry.\n")
   
   options.output = options.output or "/tmp/output"
   file = io.open (options.output, "w")

   if input.vertices then
      -- This is either a mesh or a polyhedron.

      -- TODO: replace getmetatable(input.vertices).__len() with
      -- #input.vertices when Lua 5.2 arrives.

      if getmetatable(input.vertices).__len() == input.size[1] * 3 then
	 -- Only spatial data is available.

	 for i = 0, input.size[1] - 1 do
	    file:write (string.format ("v %f %f %f\n",
				     input.vertices[i * 3 + 1],
				     input.vertices[i * 3 + 2],
				     input.vertices[i * 3 + 3]))
	 end

	 for i = 0, input.size[2] / 3 - 1 do
	    file:write (string.format ("f %d %d %d\n",
				     input.indices[i * 3 + 1] + 1,
				     input.indices[i * 3 + 2] + 1,
				     input.indices[i * 3 + 3] + 1))
	 end
      else
	 -- Output spatial, normal and texture coordinates.

	 for i = 0, input.size[1] - 1 do
	    file:write (string.format ("v %f %f %f\n",
				     input.vertices[i * 8 + 1],
				     input.vertices[i * 8 + 2],
				     input.vertices[i * 8 + 3]))
	    file:write (string.format ("vn %f %f %f\n",
				     input.vertices[i * 8 + 4],
				     input.vertices[i * 8 + 5],
				     input.vertices[i * 8 + 6]))
	    file:write (string.format ("vt %f %f\n",
				     input.vertices[i * 8 + 7],
				     input.vertices[i * 8 + 8]))
	 end

	 for i = 0, input.size[2] / 3 - 1 do
	    file:write (string.format ("f %d/%d/%d %d/%d/%d %d/%d/%d\n",
				     input.indices[i * 3 + 1] + 1,
				     input.indices[i * 3 + 1] + 1,
				     input.indices[i * 3 + 1] + 1,
				     input.indices[i * 3 + 2] + 1,
				     input.indices[i * 3 + 2] + 1,
				     input.indices[i * 3 + 2] + 1,
				     input.indices[i * 3 + 3] + 1,
				     input.indices[i * 3 + 3] + 1,
				     input.indices[i * 3 + 3] + 1))
	 end
      end

      print ("Wavefront OBJ mesh data written to " .. options.output)
   elseif input.pixels then
      local output

      -- This is a texture.

      output = imaging.writeformat (input.pixels,
				    input.size[1],
				    input.size[2],
				    "PNG")

      file:write (output)
 
      print ("PNG image data written to " .. options.output)
   elseif input.samples then
      local a, b

      -- This is wave data, that is 16 bit signed PCM samples.

      for i = 1, input.size do
	 a = (input.samples[i] + 32768) / 256
	 b = (input.samples[i] + 32768) - a * 256

	 file:write (string.char(b))
	 file:write (string.char(a))
      end
      
      print ("Monophonic 16-bit unsigned " .. tostring(input.frequency) .. 
	     " Hz PCM sample data written to " .. options.output)
   else
      assert (false,
	      "The input file does not appear to be anything convertible.\nSorry.\n")   
   end

   file:close ()
end
