-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "resources"
require "derived"
require "aviation"
require "nature"
require "widgets"
require "shapes"
require "shading"
require "transforms"
require "frames"
require "moremath"
require "moremeshes"
require "morewidgets"
require "particulate"
require "physics"
require "units"

-- These values are fixed.

graphics.title = "Techne"
graphics.window = {800, 600}
graphics.hide = false
graphics.canvas = {0.07, 0.07, 0.075}

derived.gee = units.meters(-9.81)
derived.range = units.meters{0.1, 10000}
derived.field = 47

dynamics.collision = {}
dynamics.tolerance = {1e-6, 0.2}
dynamics.popvelocity = 10
dynamics.surfacelayer = 1e-2
dynamics.stepsize = 0.01

network.http = 29176

graphics.close = function ()
		    common.iterate = false
		 end
   
graph.events = frames.event {
   keypress = function(self, key)
		 if key == 'q' then
		    common.iterate = false
		 elseif key == 'p' then
		    dynamics.timescale = dynamics.timescale > 0 and 0 or 1
		 end
	      end
}

graph.framerate = options.framerate and widgets.display {
   align = {1, 1},

   gauge = widgets.speedometer {
      color = {1.0, 0.8, 0.2},
      opacity = 0.6,
   },
}
