/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "toggle.h"

@implementation Toggle

-(Toggle *) init
{
    char *list[] = {"off", "on", "state"};
    
    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->state = 0;

    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "state")) {
	lua_pushboolean (_L, self->state);
    } else if (!xstrcmp(k, "on")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__on");
	lua_replace (_L, 2);
        lua_rawget (_L, 1);	
    } else if (!xstrcmp(k, "off")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__off");
	lua_replace (_L, 2);
        lua_rawget (_L, 1);	
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "state")) {
	if (self->state != lua_toboolean (_L, -1)) {
	    self->state = lua_toboolean (_L, -1);
	
	    /* [self toggle]; */

	    if (self->state) {
		/* Unlink off. */

		lua_getmetatable (_L, 1);
		lua_pushstring (_L, "__off");
		lua_gettable (_L, -2);
		lua_replace (_L, -2);
		
		if (!lua_isnil (_L, -1)) {    
		    lua_pushliteral (_L, "parent");
		    lua_pushnil (_L);
		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		} else {
		    lua_pop (_L, 1);
		}   
	
		/* Link on. */

		lua_getmetatable (_L, 1);
		lua_pushstring (_L, "__on");
		lua_gettable (_L, -2);
		lua_replace (_L, -2);
		
		if (!lua_isnil (_L, -1)) {    
		    lua_pushliteral (_L, "parent");

		    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
		    lua_pushlightuserdata (_L, self);
		    lua_gettable (_L, -2);
		    lua_replace (_L, -2);

		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		} else {
		    lua_pop (_L, 1);
		}  
	    } else {
		/* Unlink on. */

		lua_getmetatable (_L, 1);
		lua_pushstring (_L, "__on");
		lua_gettable (_L, -2);
		lua_replace (_L, -2);
		
		if (!lua_isnil (_L, -1)) {    
		    lua_pushliteral (_L, "parent");
		    lua_pushnil (_L);
		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		} else {
		    lua_pop (_L, 1);
		} 
		
		/* Link off. */

		lua_getmetatable (_L, 1);
		lua_pushstring (_L, "__off");
		lua_gettable (_L, -2);
		lua_replace (_L, -2);
		
		if (!lua_isnil (_L, -1)) {    
		    lua_pushliteral (_L, "parent");

		    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
		    lua_pushlightuserdata (_L, self);
		    lua_gettable (_L, -2);
		    lua_replace (_L, -2);

		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		} else {
		    lua_pop (_L, 1);
		} 
	    }
	}
    } else if (!xstrcmp(k, "on")) {
    	/* Make sure we're unlinked. */

	lua_getmetatable (_L, 1);
	lua_pushstring (_L, "__on");
	lua_gettable (_L, -2);
	lua_replace (_L, -2);
	
    	if (!lua_isnil (_L, -1)) {
    	    lua_pushliteral (_L, "parent");
    	    lua_pushnil (_L);
    	    lua_settable (_L, -3);
    	    lua_pop (_L, 1);
    	} else {
	    lua_pop (_L, 1);
	}

    	/* Link if needed. */
	
    	if (self->state && !lua_isnil (_L, 3)) {
	    lua_pushvalue (_L, 3);
    	    lua_pushliteral (_L, "parent");

    	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
    	    lua_pushlightuserdata (_L, self);
    	    lua_gettable (_L, -2);
    	    lua_replace (_L, -2);

    	    lua_settable (_L, -3);
    	    lua_pop (_L, 1);
    	}

	/* Save a reference. */
	
 	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__on");
	lua_replace (_L, 2);
        lua_rawset (_L, 1);	
    } else if (!xstrcmp(k, "off")) {
    	/* Make sure we're unlinked. */

	lua_getmetatable (_L, 1);
	lua_pushstring (_L, "__off");
	lua_gettable (_L, -2);
	lua_replace (_L, -2);
	
    	if (!lua_isnil (_L, -1)) {
    	    lua_pushliteral (_L, "parent");
    	    lua_pushnil (_L);
    	    lua_settable (_L, -3);
    	    lua_pop (_L, 1);
    	} else {
	    lua_pop (_L, 1);
	}

    	/* Link if needed. */
	
    	if (!self->state && !lua_isnil (_L, 3)) {
	    lua_pushvalue (_L, 3);
    	    lua_pushliteral (_L, "parent");

    	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
    	    lua_pushlightuserdata (_L, self);
    	    lua_gettable (_L, -2);
    	    lua_replace (_L, -2);

    	    lua_settable (_L, -3);
    	    lua_pop (_L, 1);
    	}

	/* Save a reference. */
	
 	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__off");
	lua_replace (_L, 2);
        lua_rawset (_L, 1);	
    } else {
	[super set];
    }
}

@end

