/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glu.h>
#include "texture.h"

@implementation Texture

-(Texture *) init
{
    [super init];

    self->size[0] = 0;
    self->size[1] = 0;
    self->size[2] = 0;

    self->name = 0;

    return self;
}

-(Texture *) initWithPixels: (unsigned char *) pixels
                     ofSize: (int[3]) n
           andLevelsBetween: (int) base
	                and: (int) max;
{
    GLenum error;

    GLuint t;
    GLenum formats[] = {0, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_RGBA};

    [super init];
        
    glGetError();
    glGenTextures(1, &t);
    glBindTexture(GL_TEXTURE_2D, t);

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_BASE_LEVEL, base);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAX_LEVEL, max);
	
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glPixelStorei(GL_UNPACK_ROW_LENGTH, n[0]);

    /* gluBuild2DMipmaps crashes if no GL context is bound. */
    
    if (_WINDOW) {
	gluBuild2DMipmaps (GL_TEXTURE_2D,
			   formats[n[2]],
			   n[0], n[1],
			   formats[n[2]],
			   GL_UNSIGNED_BYTE,
			   pixels);
    }

    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
		
    error = glGetError();
    if(error != GL_NO_ERROR) {
	printf ("Could not create texture (%s)\n",
		(char *)gluErrorString(error));
    }

    self->name = t;

    self->size[0] = n[0];
    self->size[1] = n[1];
    self->size[2] = n[2];
 
    return self;
}

-(void) free
{
    glDeleteTextures(1, &self->name);

    [super free];
}

-(int) width
{
    return self->size[0];
}

-(int) height
{
    return self->size[1];
}

-(int) components
{
    return self->size[2];
}

-(GLuint) index
{
    return self->name;
}

@end
