/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _STATIC_H_
#define _STATIC_H_

#include <lua.h>
#include "transform.h"

@interface Static: Transform {
    GLfloat *vertices;
    GLushort *indices;
    
    GLuint buffers[2];
    int size[2];
}

-(Static *) initWithVertices: (GLfloat *)floats
		  andIndices: (GLushort *)shorts
		      ofSize: (int[2]) n;
-(void) freeBuffers;
-(int) vertices;
-(int) indices;

@end

#endif
