/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>

#include "screen.h"

@implementation Screen

-(Screen *) init
{
    char *list[] = {"size"};

    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->size[0] = 1;
    self->size[1] = 1;
    
    return self;
}

-(void) transform
{
    double zero[3] = {0, 0, 0};

    self->allocated[0] = self->size[0] / self->size[1];
    self->allocated[1] = 1;
    
    /* Calculate our own allocation based on our children. */
    
    self->minimum[0] = 2 * self->padding[0];
    self->minimum[1] = 2 * self->padding[1];
    
    if ([self children]) {
	self->minimum[0] += [[self children] measureWidth];
	self->minimum[1] += [[self children] measureHeight];
    }
	
    /* Now reset the children. */
    
    if([self children]) {
	/* Align the child properly. */
    
	if (self->align[0] < 0) {
	    [[self children] position][0] = 0.5 * (self->minimum[0] -
						   self->allocated[0]);
	} else if (self->align[0] > 0) {
	    [[self children] position][0] = 0.5 * (self->allocated[0] -
						   self->minimum[0]);
	} else {
	    [[self children] position][0] = 0;
	}

	if (self->align[1] < 0) {
	    [[self children] position][1] = 0.5 * (self->minimum[1] -
						   self->allocated[1]);
	} else if (self->align[1] > 0) {
	    [[self children] position][1] = 0.5 * (self->allocated[1] -
						   self->minimum[1]);
	} else {
	    [[self children] position][1] = 0;
	}

	[[self children] allocated][0] = self->minimum[0];
	[[self children] allocated][1] = self->minimum[1];
    }

    [super transformRelativeTo: zero];
}

-(void) traversePass: (int)pass
{
    if (pass == 2) {
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();

	if ([self parentTransform]) {
	    glMultMatrixd ([[self parentTransform] matrix]);
	}
	
	glMultMatrixd ([self matrix]);
	glScalef (self->size[1], self->size[1], 1);
	
	glUseProgramObjectARB(0);

	/* glColor3f (1, 0, 0); */
	/* glRectf (-0.5 * self->size[0] / self->size[1], */
	/* 	 -0.5, */
	/* 	 0.5 * self->size[0] / self->size[1], */
	/* 	 0.5); */
	
	[super traversePass: pass];
    
	glMatrixMode (GL_MODELVIEW);
	glPopMatrix();
    } else {   
	[super traversePass: pass];
    }
}
    
-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "size")) {
        lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->size[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "size")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->size[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else {
	[super set];
    }
}

@end
