/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _FOURSTROKE_H_
#define _FOURSTROKE_H_

#include <lua.h>
#include <ode/ode.h>
#include "joint.h"

@interface Fourstroke: Joint {
  dJointID transmission;
  dBodyID flywheel;
  dJointFeedback output;

  double state[9];
  double anchor[3], axis[3], tolerance;
  double benchspeed, throttle, bypass;
  double inertia, peak;
  double displacement, intake[2];
  double volumetric[4], thermal[3];
  double exchange[2], friction[3];
  double *gearbox, primary;
  int cylinders, gear, gears, idle;
}

-(void) cycle;
@end

#endif
