/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _FLUID_H_
#define _FLUID_H_

#include "transform.h"

@interface Fluid: Transform {
    double *particles, *subparticles, tick, support, mobility;
    double scale[2], state[2], coefficients[2];
    double viscosity[2], stiffness[2], density, diffusion;
    unsigned int *table;

    int size, generated, hashes, clustering, iteration, granularity;
}
@end

#endif
