/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include <assert.h>
#include <lua.h>
#include <ode/ode.h>
#include <gdk/gdk.h>
#include <gdk/gdkgl.h>

lua_State *_L;
dWorldID _WORLD;
dSpaceID _SPACE;
dJointGroupID _GROUP;
GdkWindow *_WINDOW;

/* #define DRAW_VOLUMES */

#define BEGIN_ASSERT_BALANCED {		\
    int __h = lua_gettop (_L);

#define END_ASSERT_BALANCED		\
    assert (lua_gettop (_L) == __h);	\
    }

int xstrcmp (const char *a, const char *b);
int luaX_objlen (lua_State *L, int i);
void luaX_call (lua_State *L, int nargs, int nresults);
void luaX_pushunsignedbytes (lua_State *L);
void luaX_pushbytes (lua_State *L);
void luaX_pushunsignedchars (lua_State *L);
void luaX_pushchars (lua_State *L);
void luaX_pushunsignedshorts (lua_State *L);
void luaX_pushshorts (lua_State *L);
void luaX_pushunsignedints (lua_State *L);
void luaX_pushints (lua_State *L);
void luaX_pushfloats (lua_State *L);
void luaX_pushdoubles (lua_State *L);

#endif
