/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "breaker.h"

@implementation Breaker

-(Breaker *) init
{
    char *list[] = {"selected"};
    
    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->target = 0;
    self->state = 0;
    
    return self;
}

-(void) link
{
    /* Reserve a space for the selected node. */
	
    lua_pushnil(_L);
	
    lua_pushliteral (_L, "parent");
	
    /* Get a hold of ourself. */
	
    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
    lua_pushlightuserdata (_L, self);
    lua_gettable (_L, -2);
    lua_replace (_L, -2);

    /* Get the selected node and put it before the
       "parent" key. */
	
    lua_getmetatable(_L, -1);
    lua_pushstring (_L, "__selected");
    lua_gettable (_L, -2);
    lua_replace (_L, -5);
    lua_pop (_L, 1);

    if (!lua_isnil (_L, -3)) {
	/* Link the selected node to ourselves. */
	lua_settable (_L, -3);
	lua_pop (_L, 1);
    } else {
	lua_pop (_L, 3);
    }

    self->state = 1;
}

-(void) unlink
{
    /* Get a hold of ourself. */

    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
    lua_pushlightuserdata (_L, self);
    lua_gettable (_L, -2);
    lua_replace (_L, -2);

    /* Get the selected node and put it before the
       "parent" key. */

    lua_getmetatable(_L, -1);
    lua_pushstring (_L, "__selected");
    lua_gettable (_L, -2);
    lua_replace (_L, -3);
    lua_pop (_L, 1);

    /* Unlink the selected node from ourselves. */
	
    if (!lua_isnil (_L, -1)) {
	lua_pushliteral (_L, "parent");
	lua_pushnil (_L);
	lua_settable (_L, -3);
	lua_pop (_L, 1);
    } else {
	lua_pop (_L, 1);
    }

    self->state = 0;
}

-(void) finish
{
    if (self->target && !self->state) {
	[self link];
    }

    if (!self->target && self->state) {
	[self unlink];
    }
    
    [super finish];
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__selected");
	lua_replace (_L, 2);
        lua_rawget (_L, 1);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
	/* Make sure we're unlinked. */

	[self unlink];

	self->selected = *(id *)lua_touserdata(_L, 3);
	
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_pushstring (_L, "__selected");
	lua_replace (_L, 2);
        lua_rawset (_L, 1);

	/* Link if needed. */
	
	if (self->target > 0) {
	    [self link];
	}
    } else {
	[super set];
    }
}

@end
