/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _BODY_H_
#define _BODY_H_

#include <lua.h>
#include <ode/ode.h>
#include "transform.h"

@interface Body: Transform {
    dBodyID body;
    dGeomID geom;
    dSpaceID space;

    dReal velocity[3], spin[3];
    dMass mass;

    int clamped, encapsulated, debug;
@public    
    int poststep;
}

-(dBodyID) body;
-(dGeomID) geom;
-(dSpaceID) space;

-(void) fasten;
-(void) release;
-(void) insertInto: (dSpaceID) new;

-(dReal *) velocity;
-(dReal *) spin;

@end

#endif
