/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>

#include "veneer.h"

@implementation Veneer

-(void) transform
{
    double zero[3] = {0, 0, 0};

    [super transformRelativeTo: zero];
}

-(void) traversePass: (int)pass
{
    int v[4];
	
    glMatrixMode (GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();

    glGetIntegerv (GL_VIEWPORT, v);
    glOrtho(-(float)v[2] / v[3] * 0.5,
	    (float)v[2] / v[3] * 0.5,
	    -0.5, 0.5,
	    0, 1);

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();
	
    glUseProgramObjectARB(0);

    [super traversePass: pass];
    
    glMatrixMode (GL_MODELVIEW);
    glPopMatrix();
    
    glMatrixMode (GL_PROJECTION);
    glPopMatrix();
}

@end
