/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "stalker.h"

@implementation Stalker

-(Stalker *) init
{
    char *list[] = {"reference"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->reference = LUA_REFNIL;
    self->target = NULL;
    
    return self;
}

-(void) transform
{
    double *r, *t, M[16];

    if (self->target) {
	r = [self translation];
	t = [self->target translation];

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	gluLookAt(r[0], r[1], r[2],
		  t[0], t[1], t[2],
		  0, 0, 1);

	glGetDoublev (GL_MODELVIEW_MATRIX, M);
	glPopMatrix();

	self->orientation[0] = M[0];
	self->orientation[1] = M[4];
	self->orientation[2] = M[8];
    
	self->orientation[3] = M[1];
	self->orientation[4] = M[5];
	self->orientation[5] = M[9];
    
	self->orientation[6] = M[2];
	self->orientation[7] = M[6];
	self->orientation[8] = M[10];
    }
    
    [super transform];
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "reference")) {
        lua_rawgeti (_L, LUA_REGISTRYINDEX, self->reference);
    } else  {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "reference")) {
	self->target = *(id *)lua_touserdata (_L, 3);
	
	luaL_unref (_L, LUA_REGISTRYINDEX, self->reference);
        self->reference = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else {
	[super set];	
    }
}

@end
