/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "sprites.h"
#include "texture.h"

@implementation Sprites

-(Sprites *) init
{
    char *list[] = {"attenuation", "texture"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->texture = nil;
    
    self->attenuation[0] = 1;
    self->attenuation[1] = 0;
    self->attenuation[2] = 0;
    
    return self;
}

-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "texture")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else if (!xstrcmp(k, "attenuation")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->attenuation[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "attenuation")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->attenuation[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "texture")) {
        if(lua_isuserdata (_L, 3)) {
	    self->texture = *(id *)lua_touserdata (_L, 3);
	}

	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_settable (_L, 1);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    if (pass == 2) {
	glUseProgramObjectARB(0);

	if (self->texture) {
	    glActiveTexture (GL_TEXTURE0);
	    glBindTexture (GL_TEXTURE_2D, [self->texture index]);
	    glEnable (GL_TEXTURE_2D);
	}

	glDepthMask (GL_FALSE);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_BLEND);
   
	[super traversePass: pass];

	glDepthMask (GL_TRUE);    
	glDisable (GL_BLEND);
	glDisable (GL_TEXTURE_2D);
    } else {
	[super traversePass: pass];
    }
}

@end

