/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "lamp.h"
#include "shadow.h"

@implementation Shadow

-(void) traversePass: (int)pass
{
    if (pass == 1) {
	id parent, child;
		
	for (parent = [self parent]; parent; parent = [parent parent]) {
	    for (child = [parent children] ; child ; child = [child sister]) {
		if ([child isMemberOf: [Lamp class]]) {
		    double M[16], T[16], R[16];
		    double dot;

		    glMatrixMode(GL_MODELVIEW);
		    glGetDoublev (GL_MODELVIEW_MATRIX, R);
				    
		    glPushMatrix();
		    glMultMatrixd ([self matrix]);
		    glGetDoublev (GL_MODELVIEW_MATRIX, M);
		    glPopMatrix();

		    glPushMatrix();
		    glMultMatrixd ([child matrix]);
		    glGetDoublev (GL_MODELVIEW_MATRIX, T);
		    glPopMatrix();

		    dot = M[8] * (M[12] - T[12]) +
			  M[9] * (M[13] - T[13]) +
			  M[10] * (M[14] - T[14]);

		    glPushMatrix();
		    glLoadIdentity();
		    glTranslated (T[12], T[13], T[14]);
		    glMultMatrixd ((double[16]){
			     -dot, 0, 0, -M[8],
				0, -dot, 0, -M[9],
				0, 0, -dot, -M[10],
				0, 0, 0, 0});
		    glTranslated (-T[12], -T[13], -T[14]);
		    glMultMatrixd(R);

		    glEnable (GL_POLYGON_OFFSET_FILL);
		    glPolygonOffset (-3, -3);

		    [super traversePass: pass];

		    glDisable (GL_POLYGON_OFFSET_FILL);
		    glPopMatrix();
		}
	    }
	}
    } else {
	[super traversePass: pass];
    }
}

@end

