/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>

#include "row.h"

@implementation Row

-(double) measureWidth
{
    id child;

    self->minimum[0] = self->padding[0];
    
    for(child = [self children] ; child ; child = [child sister]) {
	self->minimum[0] += [child measureWidth] + self->padding[0];
    }

    return self->minimum[0];
}

-(double) measureHeight
{
    id child;

    self->minimum[1] = 2 * self->padding[1];
    
    for(child = [self children] ; child ; child = [child sister]) {
	double height;

	height = [child measureHeight] + 2 * self->padding[1];
	
	self->minimum[1] = height > self->minimum[1] ?
	                   height : self->minimum[1];
    }

    return self->minimum[1];
}

-(void) transform
{
    id child;
    double width;

    /* Align ourselves. */
    
    if (self->align[0] < 0) {
	self->position[0] += 0.5 * (self->minimum[0] - self->allocated[0]);
    } else if (self->align[0] > 0) {
	self->position[0] += 0.5 * (self->allocated[0] - self->minimum[0]);
    }

    if (self->align[1] < 0) {
	self->position[1] += 0.5 * (self->minimum[1] - self->allocated[1]);
    } else if (self->align[1] > 0) {
	self->position[1] += 0.5 * (self->allocated[1] - self->minimum[1]);
    }
	
    /* Now distribute the children in the allocated space. */
    
    for(child = [self children],
	width = self->padding[0] - 0.5 * (self->minimum[0] -
					  [child measureWidth]);
	child ;
	width += self->padding[0] + 0.5 * ([child measureWidth] +
					   [[child sister] measureWidth]),
	child = [child sister]) {
	
	[child position][0] = width;
	[child position][1] = 0;
	[child position][2] = 0;
	
	[child allocated][0] = self->minimum[0];
	[child allocated][1] = self->minimum[1];
    }

    [super transform];
}

@end

